<?php
include 'db.php';

// Ensure the orderid is set
if (!isset($_GET['orderid']) || empty($_GET['orderid'])) {
    die('Order ID is missing.');
}

$orderid = $_GET['orderid'];

// Create a connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Prepare the query to get order details
$stmt = $conn->prepare("
    SELECT 
        o.id,
        o.orderid, 
        o.actionstatus, 
        o.createdate, 
        o.storestatus,
        o.grandtotal, 
        o.paymentstatus, 
        i.invoiceno,
        c.displayname,
        c.address,
        c.city,
        c.phoneno,
        c.sname,
        c.sphoneno,
        c.saddress, 
        c.scity,
        c.spincode,
        c.sstate,
        o.balance
    FROM 
        orders o
    LEFT JOIN 
        invoice i ON i.orderid = o.id
    LEFT JOIN 
        customerpayment cp ON cp.orderid = o.id
    LEFT JOIN 
        customer c ON c.id = o.customerid
    WHERE 
        o.id = ?;
");

// Bind the parameter (assuming `id` is an integer)
$stmt->bind_param("i", $orderid);

// Execute the query
$stmt->execute();

// Bind result variables
$stmt->bind_result(
    $resultorderno, $resultOrderId, $resultActionStatus, $resultCreateDate, $resultStoreStatus, $resultGrandTotal,
    $resultPaymentType, $resultInvoiceNo, $resultDisplayName, $resultAddress, $resultCity, 
    $resultPhoneNo, $resultSName, $resultSPhoneNo, $resultSAddress, $resultSCity, 
    $resultSPincode, $resultSState, $balance
);

// Fetch the result
$orderDetails = [];
if ($stmt->fetch()) {
    $orderDetails = [
        'orderno' => htmlspecialchars($resultorderno),
        'orderid' => htmlspecialchars($resultOrderId),
        'actionstatus' => htmlspecialchars($resultActionStatus),
        'createdate' => htmlspecialchars($resultCreateDate),
        'storestatus' => htmlspecialchars($resultStoreStatus),
        'grandtotal' => htmlspecialchars($resultGrandTotal),
        'paymenttype' => htmlspecialchars($resultPaymentType),
        'invoiceno' => htmlspecialchars($resultInvoiceNo),
        'displayname' => htmlspecialchars($resultDisplayName),
        'address' => htmlspecialchars($resultAddress),
        'city' => htmlspecialchars($resultCity),
        'phoneno' => htmlspecialchars($resultPhoneNo),
        'sname' => htmlspecialchars($resultSName),
        'sphoneno' => htmlspecialchars($resultSPhoneNo),
        'saddress' => htmlspecialchars($resultSAddress),
        'scity' => htmlspecialchars($resultSCity),
        'spincode' => htmlspecialchars($resultSPincode),
        'sstate' => htmlspecialchars($resultSState),
        'products' => [],
        'balance' => htmlspecialchars($balance),
        'payment' => []
    ];
}

$stmt->close();

// Fetch all products related to this order
$stmtProducts = $conn->prepare("
    SELECT 
        p.productname, 
        p.sku, 
        od.qty, 
        od.mrp, 
        od.price, 
        od.taxvalue, 
        od.taxpercentage, 
        od.producttotal
    FROM 
        orderdatas od
    LEFT JOIN 
        product p ON p.id = od.productid
    WHERE 
        od.orderid = ?;
");

$stmtProducts->bind_param("i", $orderid);
$stmtProducts->execute();
$stmtProducts->bind_result($productname, $sku, $qty, $mrp, $price, $taxvalue, $taxpercentage, $producttotal);

$itemtotal = 0.00;
while ($stmtProducts->fetch()) {
    $orderDetails['products'][] = [
        'productname' => htmlspecialchars($productname),
        'sku' => htmlspecialchars($sku),
        'qty' => htmlspecialchars($qty),
        'mrp' => htmlspecialchars($mrp),
        'price' => htmlspecialchars($price),
        'taxvalue' => htmlspecialchars($taxvalue),
        'taxpercentage' => htmlspecialchars($taxpercentage),
        'producttotal' => htmlspecialchars($producttotal),
    ];
    $itemtotal += floatval($producttotal);
}
$orderDetails['itemtotal'] = htmlspecialchars(number_format($itemtotal, 2)); 

$stmtProducts->close();

// Fetch all payments related to this order
$stmtPayment = $conn->prepare("
    SELECT
        pc.paymentdate,
        pc.paymenttype,
        pc.amount
    FROM
        customerpayment pc
    WHERE
        pc.orderid = ?;
");

$stmtPayment->bind_param("i", $orderid);
$stmtPayment->execute();
$stmtPayment->bind_result($paymentdate, $paymenttype1, $amount);

while ($stmtPayment->fetch()) {
    $orderDetails['payment'][] = [
        'paymentdate' => htmlspecialchars($paymentdate),
        'paymenttype1' => htmlspecialchars($paymenttype1),
        'amount' => htmlspecialchars($amount),
    ];
}

$stmtPayment->close();
$conn->close();

// Send the result as JSON
header('Content-Type: application/json');
echo json_encode($orderDetails);
?>
